USE STD.TEXTIO.ALL;
PACKAGE p_cpu IS    
  TYPE t_instr IS (jump, load, 
                   store, addd, 
                   subb, test, noop);
    
  FUNCTION convertstring( s : STRING) RETURN t_instr;
 
END p_cpu; 

PACKAGE BODY p_cpu IS    
  FUNCTION convertstring( s : STRING) RETURN t_instr IS
    SUBTYPE twochar IS string(1 to 2);
    VARIABLE val : twochar;    
  BEGIN
    val := s(1 to 2);        
    CASE val IS
           
      WHEN "ju" =>     
        RETURN jump;            
      WHEN "lo" =>  
        RETURN load;            
      WHEN "st" =>
        RETURN store;            
      WHEN "ad" =>
        RETURN addd;            
      WHEN "su" =>
        RETURN subb;            
      WHEN "te" =>
        RETURN test;            
      WHEN "no" =>
        RETURN noop;            
      WHEN others =>
        RETURN noop;        
    END CASE;    
  END convertstring; 
END p_cpu;
 
USE WORK.p_cpu.ALL;
USE STD.TEXTIO.ALL; 
ENTITY cpu_driver IS    
  PORT( next_instr : IN BOOLEAN;          
        instr : OUT t_instr;          
        src : OUT INTEGER;          
        dst : OUT INTEGER); 
END cpu_driver; 

ARCHITECTURE a_cpu_driver OF cpu_driver IS
  FILE instr_file : TEXT IS IN "instfile"; 
BEGIN    
  read_instr : PROCESS( next_instr)        
    VARIABLE aline : LINE;        
    VARIABLE a_instr : STRING(1 to 4);        
    VARIABLE asrc, adst : INTEGER;    
  BEGIN        
    IF next_instr THEN            
      IF ENDFILE(instr_file) THEN                
        ASSERT FALSE 
          REPORT "end of instructions"
          SEVERITY WARNING;            
      ELSE                
        READLINE( instr_file, aline);
        READ( aline, a_instr);                
        READ( aline, asrc);                
        READ( aline, adst);            
      END IF;
            
      instr <= convertstring(a_instr);            
      src <= asrc;            
      dst <= adst;
        
    END IF;    
  END PROCESS read_instr; 
END a_cpu_driver;




